/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnEquipmentChanged;
import com.mlib.contexts.OnPickupXp;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class EnlightenmentEnchantment
extends CustomEnchantment {
    public EnlightenmentEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.ARMOR).slots(EquipmentSlots.ARMOR).maxLevel(2).minLevelCost(level -> level * 12 + 6).maxLevelCost(level -> level * 12 + 26);
    }

    @AutoInstance
    public static class Handler {
        final DoubleConfig experienceMultiplier = new DoubleConfig(0.25, new Range((Number)0.01, (Number)10.0));
        final Supplier<EnlightenmentEnchantment> enchantment = Registries.ENLIGHTENMENT;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Enlightenment").comment("Increases the experience gained from any source.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnPickupXp.listen(this::increaseExperience).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).addConfig((IConfigurable)this.experienceMultiplier.name("experience_extra_multiplier").comment("Extra percent of experience acquired from all sources per enchantment level.")).insertTo(group);
            OnEquipmentChanged.listen(this::giveAdvancement).addCondition(Condition.predicate(data -> data.entity instanceof ServerPlayer)).addCondition(Condition.predicate(data -> this.enchantment.get().getEnchantmentSum(data.entity, EquipmentSlots.ARMOR) == 8)).insertTo(group);
        }

        private void increaseExperience(OnPickupXp.Data data) {
            int enlightenmentSum = this.enchantment.get().getEnchantmentSum((LivingEntity)data.player, EquipmentSlots.ARMOR);
            int experiencePoints = Random.round((double)((double)enlightenmentSum * (Double)this.experienceMultiplier.get() * (double)data.event.getOrb().m_20801_()));
            if (experiencePoints > 0) {
                data.player.m_6756_(experiencePoints);
            }
        }

        private void giveAdvancement(OnEquipmentChanged.Data data) {
            Registries.HELPER.triggerAchievement((ServerPlayer)data.entity, "enlightenment_8");
        }
    }
}

